<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class City extends Model 
{

    protected $table = 'cities';
    public $timestamps = true;
    protected $fillable = array('county_id', 'name');

    public function user()
    {
        return $this->hasMany('App\Models\User', 'user_id');
    }

    public function county()
    {
        return $this->belongsTo('App\Models\County', 'county_id');
    }

}